/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.animation;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.animation.AdvancedAnimation;
import de.keksuccino.fancymenu.menu.animation.ResourcePackAnimationRenderer;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.konkrete.gui.screens.SimpleLoadingScreen;
import de.keksuccino.konkrete.localization.Locals;
import de.keksuccino.konkrete.rendering.RenderUtils;
import de.keksuccino.konkrete.rendering.animation.IAnimationRenderer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;

public class AnimationLoadingScreen
extends SimpleLoadingScreen {
    private Screen fallback;
    private List<IAnimationRenderer> renderers = new ArrayList<IAnimationRenderer>();
    private boolean ready = false;
    private int cachedFPS;
    private boolean cachedLoop;
    private boolean done = false;
    private volatile boolean preparing = false;
    private String specialString;

    public AnimationLoadingScreen(@Nullable Screen fallbackGui, IAnimationRenderer ... renderer) {
        super(Minecraft.func_71410_x());
        this.renderers.addAll(Arrays.asList(renderer));
        this.fallback = fallbackGui;
        this.setDarkmode((Boolean)FancyMenu.config.getOrDefault("loadingscreendarkmode", (Object)false));
        String defaultColor = "#ffffffff";
        String hex = (String)FancyMenu.config.getOrDefault("loadinganimationcolor", (Object)defaultColor);
        Color c = RenderUtils.getColorFromHexString((String)hex);
        if (c != null) {
            this.setLoadingAnimationColor(hex);
        } else {
            this.setLoadingAnimationColor(defaultColor);
        }
        this.specialString = AnimationLoadingScreen.getVerySpecialString();
    }

    public void func_230430_a_(MatrixStack matrix, int p_render_1_, int p_render_2_, float p_render_3_) {
        final IAnimationRenderer current = this.getCurrentRenderer();
        if (current == null) {
            this.done = true;
            this.onFinished();
            if (this.fallback != null) {
                Minecraft.func_71410_x().func_147108_a(this.fallback);
                MenuCustomization.reloadCurrentMenu();
            }
        } else {
            if (!this.ready) {
                this.cachedFPS = current.getFPS();
                this.cachedLoop = current.isGettingLooped();
                current.setFPS(-1);
                current.setLooped(false);
                this.ready = true;
            }
            if (!current.isReady()) {
                if (!this.preparing) {
                    final AnimationLoadingScreen loading = this;
                    this.preparing = true;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (((Boolean)FancyMenu.config.getOrDefault("showanimationloadingstatus", (Object)true)).booleanValue()) {
                                loading.setStatusText(Locals.localize((String)"loading.animation.loadingframes", (String[])new String[]{current.getPath().replace("/", ".").replace("\\", ".")}));
                            }
                            current.prepareAnimation();
                            System.gc();
                            loading.preparing = false;
                        }
                    }).start();
                }
            } else if (!current.isFinished()) {
                if (((Boolean)FancyMenu.config.getOrDefault("showanimationloadingstatus", (Object)true)).booleanValue()) {
                    this.setStatusText(Locals.localize((String)"loading.animation.prerendering", (String[])new String[]{current.getPath().replace("/", ".").replace("\\", ".")}));
                }
                if (current instanceof AdvancedAnimation) {
                    ((AdvancedAnimation)current).setMuteAudio(true);
                }
                current.render(matrix);
                if (current instanceof AdvancedAnimation) {
                    ((AdvancedAnimation)current).setMuteAudio(false);
                }
            } else {
                current.setFPS(this.cachedFPS);
                current.setLooped(this.cachedLoop);
                current.resetAnimation();
                this.renderers.remove(0);
                this.ready = false;
            }
        }
        super.func_230430_a_(matrix, p_render_1_, p_render_2_, p_render_3_);
        if (this.specialString != null) {
            FontRenderer r = Minecraft.func_71410_x().field_71466_p;
            int i = r.func_78256_a(this.specialString) / 2;
            r.func_238405_a_(matrix, this.specialString, (float)(this.field_230708_k_ / 2 - i), 20.0f, Color.WHITE.getRGB());
        }
    }

    private IAnimationRenderer getCurrentRenderer() {
        if (!this.renderers.isEmpty()) {
            IAnimationRenderer r = this.renderers.get(0);
            if (r instanceof ResourcePackAnimationRenderer) {
                this.renderers.remove(0);
                return this.getCurrentRenderer();
            }
            if (r instanceof AdvancedAnimation) {
                IAnimationRenderer main = ((AdvancedAnimation)r).getMainAnimationRenderer();
                if (main == null) {
                    return null;
                }
                if (main instanceof ResourcePackAnimationRenderer) {
                    this.renderers.remove(0);
                    return this.getCurrentRenderer();
                }
            }
            return r;
        }
        return null;
    }

    public void onFinished() {
        this.setStatusText(Locals.localize((String)"loading.animation.done", (String[])new String[0]));
    }

    public boolean loadingFinished() {
        return this.done;
    }

    private static String getVerySpecialString() {
        try {
            Calendar c = Calendar.getInstance();
            int day = c.get(5);
            int month = c.get(2) + 1;
            int hour = c.get(11);
            int minute = c.get(12);
            int second = c.get(13);
            if (day == 14 && month == 2) {
                return "\u00a7dHappy Valentine's Day! \u2764";
            }
            if (day == 24 && month == 12) {
                return "\u00a7cMerry Christmas!";
            }
            if (hour == 0 && minute == 0) {
                return "\u00a74OoOoOoOoOoOoO Spoooooky!";
            }
            if (day == 1 && month == 1) {
                return "\u00a7dHappy New Year!";
            }
            if (day == 31 && month == 10) {
                return "\u00a76Happy Halloweeeeen!";
            }
            if (day == 7 && month == 7) {
                return "\u00a7dHappy Tanabata! \u5e78\u305b\u4e03\u5915\uff01";
            }
            if (day == 21 && month == 2 && hour == 19) {
                return "\u00a7bAvatar State, Yip Yip!";
            }
            if (hour == 16 && minute == 20 && second >= 0 && second <= 3) {
                return "\u00a72420";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

